import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/helper/date_converter.dart';
import 'package:viser_remit/core/helper/string_format_helper.dart';
import 'package:viser_remit/data/services/api_client.dart';
import 'package:viser_remit/view/components/divider/custom_divider.dart';
import 'package:viser_remit/view/components/status/history_status_section.dart';

import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';
import '../../../../../core/utils/util.dart';
import '../../../../../data/controller/home/home_controller.dart';
import '../../../../components/custom_no_data_found_class.dart';

class RecentSection extends StatelessWidget {
  final HomeController controller;

  const RecentSection({super.key, required this.controller});

  @override
  Widget build(BuildContext context) {
    var apiClient = Get.find<ApiClient>();

    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 8,vertical: 8),
      decoration: BoxDecoration(
        color: MyColor.colorWhite,
        borderRadius: BorderRadius.circular(8)
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // const SizedBox(height: Dimensions.space24),
          Text(MyStrings.recentTransaction.tr, style: boldExtraLarge),
          const SizedBox(height: Dimensions.space11),
          controller.recentTransactionList.isEmpty
              ? const NoDataOrInternetScreen()
              : Column(
                  children: List.generate(controller.recentTransactionList.length, (index) {
                    var recentTransaction = controller.recentTransactionList[index];
                    double paymentTotalAmount;
                    paymentTotalAmount = (double.parse(recentTransaction.baseCurrencyAmount!) + double.parse(recentTransaction.baseCurrencyCharge!));

                    if (recentTransaction.deposit != null) {
                      paymentTotalAmount += double.parse(recentTransaction.deposit!.charge!);
                    }
                    return Column(
                      children: [
                        Container(
                          padding: const EdgeInsets.symmetric(vertical: 0, horizontal: 16),
                          // margin: const EdgeInsetsDirectional.only(bottom: 8),
                          color: MyColor.colorWhite,
                          child: Row(
                            children: [
                              Expanded(
                                flex: 6,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Text(DateConverter.convertIsoToString(recentTransaction.createdAt.toString()), style: mediumDefault.copyWith(color: MyColor.bodyTextColor)),
                                    const SizedBox(height: Dimensions.space5,),
                                    Text("${Converter.formatNumber(paymentTotalAmount.toString())} ${apiClient.getCurrencyOrUsername(isCurrency: true).tr}".tr, style: boldLarge),
                                    const SizedBox(height: Dimensions.space10,),

                                    Text(recentTransaction.recipient?.name ?? "".tr, style: boldLarge),
                                  ],
                                ),
                              ),
                              // const SizedBox(width: Dimensions.space24,),
                              Expanded(
                                flex: 5,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.end,
                                  children: [
                                    HistoryStatusSection(status: recentTransaction.paymentStatus.toString(), isDepositAvailable: recentTransaction.deposit == null ? false : true),

                                    const SizedBox(height: Dimensions.space8),
                                    Text("${Converter.formatNumber(recentTransaction.sendingCharge.toString())} ${recentTransaction.sendingCurrency}", style: regularDefault.copyWith(color: MyColor.colorRed)),

                                    const SizedBox(height: Dimensions.space8),
                                    Text(recentTransaction.countryDeliveryMethod?.deliveryMethod?.name.toString() ?? "", style: regularLarge),
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                        index == controller.recentTransactionList.length -1 ? SizedBox.shrink() : const CustomDivider(thickness: 1.5,)
                      ],
                    );
                  }),
                ),
        ],
      ),
    );
  }
}
